function [focalCode]=string2code(focal)


% Convert the coded focal element to String
%
% [focalString]=code2String(focal)
%
% Input:
% focal = list of the focal elements such as {'1u2' '(2n10)u5'}
%
% Output:
% focalString = list of the focal elements such as {[1 -1 2] [-3 2 -2 10 -4 -1 5]}
% 
% March 2008 Arnaud MARTIN


nbFoc=size(focal,2);

for i=1:nbFoc
    nbElem=size(focal{i},2);
    code=[];
    fNum=1;
    for j=1:nbElem
        elem=focal{i}(j);
        switch elem
            case 'u' 
                code=[code str2num(focal{i}(fNum:j-1))];
                code=[code -1];
                fNum=j+1;
            case 'n'
                code=[code str2num(focal{i}(fNum:j-1))];
                code=[code -2];
                fNum=j+1;
            case '('
                code=[code str2num(focal{i}(fNum:j-1))];
                code=[code -3];
                fNum=j+1;
            case ')'
                code=[code str2num(focal{i}(fNum:j-1))];
                code=[code -4];
                fNum=j+1;
        end
    end
    code=[code str2num(focal{i}(fNum:end))];
    focalCode{i}=code;
    
end
