function [focOut]=reduceFocal(focIn)

% The goal of this function is to reduce the number of focal element during
% the combination
% 
% [expOut]=reduceFocal(focIn)
% 
% Input:
% focIn = structure of the list of focal elements (could be the same)
% 
% Output:
% focOut = structure of the list of focal elements (cannot be the same) 
%
% April 2008 Arnaud MARTIN

sizefoca=size(focIn,2);

ind=[];
nbfoc=1;
indtmp=findeqcell(focIn,focIn{1});
ind=[ind indtmp];
focOut(nbfoc)={focIn{1}};
nbfoc=nbfoc+1;

i=2;
while sizefoca~=size(ind,2)
    while ~ismember(i,ind)
        indtmp=findeqcell(focIn,focIn{i});
        ind=[ind indtmp];
        focOut(nbfoc)={focIn{i}};
        nbfoc=nbfoc+1;
    end
    i=i+1;
end

        