function [expOut]=reduceExpert(expIn)

% The goal of this function is to reduce the number of focal element during
% the combination
% 
% [expOut]=reduceExpert(expIn)
% 
% Input:
% expIn = structure of the list of focal elements (could be the same) and corresponding bba
% 
% Output:
% expOut = structure of the list of focal elements (cannot be the same) and
% corresponding bba
%
% March 2008 Arnaud MARTIN

sizefoca=size(expIn.focal,2);

ind=[];
nbfoc=1;
indtmp=findeqcell(expIn.focal,expIn.focal{1});
ind=[ind indtmp];
expOut.focal(nbfoc)={expIn.focal{1}};
expOut.bba(nbfoc)=sum(expIn.bba(indtmp));
nbfoc=nbfoc+1;

i=2;
while sizefoca~=size(ind,2)
    while ~ismember(i,ind)
        indtmp=findeqcell(expIn.focal,expIn.focal{i});
        ind=[ind indtmp];
        expOut.bba(nbfoc)=sum(expIn.bba(indtmp));
        expOut.focal(nbfoc)={expIn.focal{i}};
        nbfoc=nbfoc+1;
    end
    i=i+1;
end

        