function [DTheta]=generationDThetar(Theta)


% Generation of DThetar: modified and adapted code from Dezert & Smarandache Chapter 2 DSmT book
% Vol 1 to generate DTeta
%
% [DTheta]=generationDThetar(Theta)
%
% Input:
% Theta = list of coded (and eventually reduced with constraint) of the elements of
%         the discernement space
%
% Output:
% DTheta = list of coded (and eventually reduced with constraint in this case some elements can be the same) 
%         of the elements of the DTheta
%
% April 2008 Arnaud MARTIN
   
n=size(Theta,2);
step =1;
for i=1:n
    basetmp(step)={[Theta{i}]};
    step=step+1;
    indatom=step;
    for step2=1:indatom-2
        basetmp(step)={intersect(basetmp{indatom-1},basetmp{step2})};
        step=step+1;
    end
end

sBaseTmp=size(basetmp,2);
step=1;
for i=1:sBaseTmp
    if ~isempty(basetmp{i})
        base(step)=basetmp(i);
        step=step+1;
    end
end

sBase=size(base,2);
DTheta{1}=[];
step=1;
nbC=2;
stop=0;
D_n1 =[0 ; 1];
sDn1=2;
for nn=1:n 
    D_n =[ ] ;

    cfirst=1+(nn==n);
    for i =1:sDn1 
        Li=D_n1(i,:);
        sLi=size(Li,2);
        if (2*sLi>sBase)&& (Li(sLi-(sBase-sLi))==1)
            stop=1;
            break
        end

        for j=i:sDn1
            Lj=D_n1(j,:); 
            if(and(Li,Lj)==Li)&(or(Li,Lj)==Lj)
                D_n=[D_n ; Li Lj ] ;
                
                if size(D_n,1)>step
                    step=step+1;
                    DTheta{step}=[];
                    for c=cfirst:nbC
                        if D_n(end,c)
                            if isempty(DTheta{step})
                                DTheta{step}=base{sBase+c-nbC};
                            else
                                DTheta{step}=union(DTheta{step},base{sBase+c-nbC});
                            end
                        end
                    end
                end
            end
        end
    end
    if stop
        break
    end
    D_n1=D_n;
    sDn1=size(D_n1,1);
    nbC=2*size(D_n1,2); 
end
