function [focalDecod]=decodingFocal(focal,elemDec,Theta)


% The goal of this function is to decode the focal elements
% 
% [focalDecod]=decodingFocal(focal,elemDec,Theta)
% 
% Inputs:
% expert = containt the structure of the list of focal elements after combination and
% corresponding bba for all the experts
% elemDec = the description of the subset of uncoded elements for decision
% Theta = list of coded (and reduced with constraint) of the elements of
%         the discernement space%
% Output:
% focalDecod = containt the list of decoded (for human) focal elements 
%
% April 2008 Arnaud MARTIN


switch elemDec{1}
    case {'F','A','SF','Cm'}
        opt=1;
    case 'S'
        opt=0;
        elemDecC=Theta;
        for i=1:size(Theta,2)
            elemDec(i)={[i]};
        end
    case '2T'
        opt=0;
        natoms=size(Theta,2);
        elemDecC(1)={[]};
        elemDec(1)={[]};
        step =2;
        for i=1:natoms
            elemDecC(step)=codingFocal({[i]},Theta);
            elemDec(step)={[i]};
            step=step+1;
            indatom=step;
            for step2=2:indatom-2
                elemDec(step)={[elemDec{step2} -1 elemDec{indatom-1}]};
                elemDecC(step)={[union(elemDecC{step2},elemDecC{indatom-1})]};
                step=step+1;
            end
        end

    otherwise
        opt=0;
        elemDecN=string2code(elemDec);
        elemDecC=codingFocal(elemDecN,Theta);
end


if ~opt
    sFoc=size(focal,2);
    for foc=1:sFoc
        [ind]=findeqcell(elemDecC,focal{foc});
        if isempty(ind)
            'Accident in decodingFocal: elemDec does not be 2T'
            pause
        else
            focalDecod(foc)=elemDec(ind);  
        end
    end
else
    
    focalDecod=cell(size(focal));
    cmp=0;

    natoms=size(Theta,2);
    sFocal=size(focal,2);

    

    ind.s(1)={[]};
    ind.c(1)={[]};
    
    indice=findeqcell(focal,[]);
    if ~isempty(indice)
        cmp=cmp+1; 
        focalDecod(indice)={[]};
    end

    step=2;
    stepb=1;
    for i=1:natoms
        ind.s(end+1)={[i]};
        if ~isempty(Theta{i})
            base(stepb)={[i]};
            stepb=stepb+1;
        end
        codInd=codingFocal(ind.s(step),Theta);
        ind.c(end+1)=codInd;
        indice=findeqcell(focal,codInd{1});
        if ~isempty(indice)
            cmp=cmp+1;
            focalDecod(indice)=ind.s(end);
        end

        step=step+1;
        indatomb=stepb;
        indatom=step;
        step2=2;
        while step2<indatom-1 && cmp<sFocal  
             % intersection
               [focalDecod,ind,cmp,step,elem]=addElem(ind.s{step2},ind.s{indatom-1},-2,ind,cmp,step,focal,focalDecod,Theta);
               
               % union
               [focalDecod,ind,cmp,step,elem]=addElem(ind.s{step2},ind.s{indatom-1},-1,ind,cmp,step,focal,focalDecod,Theta);  
           if step2-1<indatomb-1
                base(end+1)=addElemBase(base{step2-1},base{indatomb-1},-2,Theta);
                stepb=stepb+1;
           end
          
            step2=step2+1;
        end

    end
    
    
    
    
    if cmp<sFocal
        sBase=size(base,2);
        
        step=1;
        nbC=2;
        D_n1 =[0 ; 1];
        sDn1=2;
        stop=0;
        for nn=1:natoms 
            D_n =[ ] ;

            cfirst=1+(nn==natoms);
            for i =1:sDn1 
                Li=D_n1(i,:);
                sLi=size(Li,2);
                if (2*sLi>sBase)&& (Li(sLi-(sBase-sLi))==1)
                    stop=1;
                    break
                end

                for j=i:sDn1
                    Lj=D_n1(j,:); 
                    if(and(Li,Lj)==Li)&(or(Li,Lj)==Lj)
                        D_n=[D_n ; Li Lj ] ;               
                        
                        if size(D_n,1)>step
                            step=step+1;
                            elemTmp=[];
                            for c=cfirst:nbC-1
                                if D_n(end,c) && ~isempty(base{sBase+c-nbC})
                                    if isempty(elemTmp)
                                        elemTmp=base{sBase+c-nbC};
                                    else
                                        [focalDecod,ind,cmp,step,elem]=addElem(elemTmp,base{sBase+c-nbC},-1,ind,cmp,step,focal,focalDecod,Theta); % union
                                        elemTmp=elem{1};
                                        
                                        if cmp==sFocal
                                            break
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
            if stop || (cmp==sFocal)
                break
            end
            D_n1=D_n;
            sDn1=size(D_n1,1);
            nbC=2*size(D_n1,2); 
        end
    end
end
end

function [focalDecod,ind,cmp,step,elem]=addElem(a,b,oper,ind,cmp,step,focal,focalDecod,Theta)

    if size(a,2)~=1 % add to a ( and ) if necessary
        indneg=find(a<0);
        if indneg(end)~=-4
            indoper=find(a==-1 | a==-2);
            if ~isempty(indoper) & a(indoper(end))~=oper    %if size(find(a<0),2)~=size(find(a==oper),2)
                a=[-3 a -4];
            end
        end
    end
    if size(b,2)~=1 % add to b ( and ) if necessary
        indneg=find(b<0);
        if indneg(end)~=-4
            indoper=find(b==-1 | b==-2);
            if ~isempty(indoper) & b(indoper(end))~=oper    %if size(find(a<0),2)~=size(find(a==oper),2)
                b=[-3 b -4];
            end
        end
       
    end
    elem={[a oper b]};

    codInd=codingFocal(elem,Theta);
    if ~isempty(codInd{1})
        indElem=findeqcell(ind.c,codInd{1});
        if isempty(indElem)
            ind.s(step)=elem;
            ind.c(step)=codInd(1);
            step=step+1;
            indice=findeqcell(focal,codInd{1});
            if ~isempty(indice) & isempty(focalDecod{indice})
                cmp=cmp+1;
                focalDecod(indice)=elem;  
            end
        else
            elem=ind.s(indElem);
        end
    end
end


function [elem]=addElemBase(a,b,oper,Theta)

if isempty(a) || isempty(b)
    elem={[]};
else
    if size(a,2)~=1  % add to a ( and ) if necessary
        indneg=find(a<0);
        if indneg(end)~=-4
            indoper=find(a==-1 | a==-2);
            if ~isempty(indoper) & a(indoper(end))~=oper    %if size(find(a<0),2)~=size(find(a==oper),2)
                a=[-3 a -4];
            end
        end
    end
    if size(b,2)~=1 % add to b ( and ) if necessary
        indneg=find(b<0);
        if indneg(end)~=-4
            indoper=find(b==-1 | b==-2);
            if ~isempty(indoper) & b(indoper(end))~=oper    %if size(find(a<0),2)~=size(find(a==oper),2)
                b=[-3 b -4];
            end
        end
        
    end
    elem={[a oper b]};
    
    codInd=codingFocal(elem,Theta);
    if isempty(codInd{1})
        elem={[]};
    end
end
end
