function [expertDecod]=decodingExpert(expert,Theta)


% The goal of this function is to decode the focal elements in expert
% 
% [expertDecod]=decodingExpert(expert,Theta)
% 
% Inputs:
% expert = containt the structure of the list of focal elements after combination and
% corresponding bba for all the experts (generally use for only one after
% combination)
% Theta = list of coded (and reduced with constraint) of the elements of
%         the discernement space%
% Output:
% expertDecod = containt the structure of the list of decoded (for human) focal elements and
% corresponding bba for all the experts
%
% April 2008 Arnaud MARTIN


    nbExp=size(expert,2);
    for exp=1:nbExp
        focal=expert(exp).focal;
        expertDecod(exp).focal=decodingFocal(focal,{'A'},Theta);
        expertDecod(exp).bba=expert(exp).bba;
    end

end