function [focalC]=codingFocal(focal,Theta)


% Code the focal element for DSmT framework
% 
% [focalC]=codingFocal(focal,Theta)
% 
% Inputs:
% focal = the list of focal element for one expert
% Theta = the description of Theta after coding
%
% Output:
% focalC = the list of coded focal element for one expert
%
% March 2008 Arnaud MARTIN


    nbfoc=size(focal,2);
    if nbfoc
        for foc=1:nbfoc
            elemC=treat(focal{foc},Theta);
            focalC{foc}=elemC;
        end
    else
        focalC={[]};
    end
    
end
        

function [elemE]=eval(oper,a,b)

    if oper==-2
        elemE=intersect(a,b);
    else
        elemE=union(a,b);
    end
end



function [elemC,cmp]=treat(focal,Theta)

    nbelem=size(focal,2);
    PelemC=0;
    oper=0;
    e=1;
    if nbelem
        while e <= nbelem
           elem=focal(e);
           switch elem
               case -1
                   oper=-1;
               case -2
                   oper=-2;
               case -3
                  [elemC,nbe]=treat(focal(e+1:end),Theta);
                  e=e+nbe;
                  
                   if oper~=0 & ~isequal(PelemC,0)
                       elemC=eval(oper,PelemC,elemC);               
                       oper=0;
                   end
                   PelemC=elemC;

               case -4
                   cmp=e;
                   e=nbelem;
               otherwise
                   elemC=Theta{elem};   
                   if oper~=0 & ~isequal(PelemC,0)
                       elemC=eval(oper,PelemC,elemC);               
                       oper=0;
                   end
                   PelemC=elemC;
           end
           e=e+1;
        end
    else
        elemC=[];
    end
end




