function [expertC]=codingExpert(expert,Theta)

% Code the focal element for DSmT framework
% 
% [expertC]=codingExpert(expert,Theta)
% 
% Inputs:
% expert = structure containing the list of focal elements for each expert
% and the bba corresponding
% Theta = the description of Theta after coding
% 
% Output:
% expertC = structure containing the list of coded focal element for each
% expert and the bba corresponding
% 
% March 2008 Arnaud MARTIN

    nbExp=size(expert,2);
    for exp=1:nbExp
       focal=string2code(expert(exp).focal);
       expertC(exp).focal=codingFocal(focal,Theta);
       expertC(exp).bba=expert(exp).bba;
    end
end

