function [focalString]=code2string(focal)


% Convert the string focal element to coded focal element
%
% [focalString]=code2String(focal)
%
% Input:
% focal = list of the focal elements such as {[1 -1 2] [-3 2 -2 10 -4 -1 5]}
%
% Output:
% focalString = list of the focal elements such as {'1u2' '(2n10)u5'}
% 
% March 2008 Arnaud MARTIN


nbFoc=size(focal,2);

for i=1:nbFoc
    nbElem=size(focal{i},2);
    ch='';
    for j=1:nbElem
        elem=focal{i}(j);
        switch elem
            case -1 
                ch=strcat(ch,'u');
            case -2
                ch=strcat(ch,'n');
            case -3
                ch=strcat(ch,'(');
            case -4
                ch=strcat(ch,')');
            otherwise
                ch=strcat(ch,num2str(elem));
        end
    end
    focalString{i}=ch;
    
end
