function [ThetaR]=addConstraint(constraint,Theta)

% Code ThetaR the reduced form of Theta taking into account the constraints given by the user
%
% [ThetaR]=addConstraint(constraint,Theta)
% 
% Inputs:
% constraint = the list of element considered as constraint or '2T' to work
% on 2^Theta
% Theta = the description of Theta after coding
%
% Output:
% ThetaR = the description of coded Theta after reduction taking into
% account the constraints
%
% March 2008 Arnaud MARTIN


if strcmp(constraint{1}, '2T')
    n=size(Theta,2);
    nbCons=1;
    for i=1:n
        for j=i+1:n
            constraint(nbCons)={[i -2 j]};
            nbCons=nbCons+1;
        end
    end
else
    constraint=string2code(constraint);
end

constraintC=codingFocal(constraint,Theta);

sConstraint=size(constraintC,2);
unionCons=[];
for i=1:sConstraint
    unionCons=union(unionCons,constraintC{i});
end

sTheta=size(Theta,2);
for i=1:sTheta
    ThetaR{i}=setdiff(Theta{i},unionCons);
end
    
    



