
function fuse(expert,constraint,n,criteriumComb,criteriumDec,mode,elemDec,display)


% To fuse experts' opinions
% 
% fuse(expert,constraint,n,criteriumComb,criteriumDec,mode,elemDec,display)
% 
% Inputs:
% expertC = containt the structure of the list of coded focal elements and
% corresponding bba for all the experts
% constraint = the empty elements 
% elemDec = list of elements on which we can decide
% n = size of the discernment space
% criteriumComb = is the combination criterium
%                   criteriumComb=1 Smets criterium
%                   criteriumComb=2 Dempster-Shafer criterium (normalized)
%                   criteriumComb=3 Yager criterium
%                   criteriumComb=4 disjunctive combination criterium
%                   criteriumComb=5 Florea criterium
%                   criteriumComb=6 PCR6 
%                   criteriumComb=7 Mean of the bbas
%                   criteriumComb=8 Dubois criterium (normalized and disjunctive
%                   combination)
%                   criteriumComb=9 Dubois and Prade criterium (mixt combination)
%                   criteriumComb=10 Mixt Combination (Martin and Osswald criterium)
%                   criteriumComb=11 DPCR (Martin and Osswald criterium)
%                   criteriumComb=12 MDPCR (Martin and Osswald criterium)
%                   criteriumComb=13 Zhang's rule
%
%
% criteriumDec = is the combination criterium
%                   criteriumDec=0 maximum of the bba 
%                   criteriumDec=1 maximum of the pignistic probability 
%                   criteriumDec=2 maximum of the credibility
%                   criteriumDec=3 maximum of the credibility with reject
%                   criteriumDec=4 maximum of the plausibility
%                   criteriumDec=5 Appriou criterium
%                   criteriumDec=6 DSmP criterium
%
% mode = 'static' or 'dynamic'
% elemDec = list of elements on which we can decide, 
%          or A for all, S for singletons only, F for focal elements only,
%          SF for singleton plus focal elements, Cm for given specificity, 
%          2T for only 2^Theta (DST case)
% display = kind of display
%       display = 0 for no display, 
%       display = 1 for combination display, 
%       display = 2 for decision display, 
%       display = 3 for both displays
%
% Output:
% res = containt the structure of the list of focal elements and
% corresponding bbas for the combinated experts
%
% March 2008 Arnaud MARTIN
% April 2008 add the inputs elemDec and the display



% Coding
Theta=codingTheta(n);
ThetaRed=addConstraint(constraint,Theta);
expertCod=codingExpert(expert,ThetaRed);

%%%
switch nargin
    case 1:5
        mode='static';
        elemDec=ThetaRed;
        display=2;
    case 6
        elemDec=ThetaRed;
        display=2;
    case 7
        elemDec=string2code(elemDec);
        display=2;
end
%%%

% Combination
if strcmp(mode, 'static')
    [expertComb]=combination(expertCod,ThetaRed,criteriumComb);
else % dynamic case
    nbexp=size(expertCod,2);
    expertTmp(1)=expertCod(1);
    for exp=2:nbexp
        expertTmp(2)=expertCod(exp);
        expertTmp(1)=combination(expertTmp,ThetaRed,criteriumComb);
    end
    expertComb=expertTmp(1);
end


% Decision
[decFocElem]=decision(expertComb,ThetaRed,criteriumDec,elemDec);



% Display
switch display
    case 0
        'no display'
    case 1
        % Result of the combination
        sFocal=size(expertComb.focal,2);
        focalRec=decodingExpert(expertComb,ThetaRed);
        focal=code2string(focalRec)
        for i=1:sFocal
            disp ( [ focal{i},'=',num2str(expertComb.bba(i)) ] )
        end
    case 2
        % Result of the decision
        if isstruct(decFocElem)
            focalDec=decodingFocal(decFocElem.focal,elemDec,ThetaRed);
            disp(['decision:',code2string(focalDec)])
        else
            disp(['decision: rejected'])
        end
    case 3
        % Result of the combination
        sFocal=size(expertComb.focal,2);
        expertDec=decodingExpert(expertComb,ThetaRed);
        focal=code2string(expertDec.focal)
        for i=1:sFocal
            disp ( [ focal{i},'=',num2str(expertDec.bba(i)) ] )
        end
        % Result of the decision
        if isstruct(decFocElem)
            focalDec=decodingFocal(decFocElem.focal,elemDec,ThetaRed);
            disp(['decision:',code2string(focalDec)])
        else
            disp(['decision: rejected'])
        end
    otherwise
        'Accident in fuse: choice of display is uncorrect'
end
    


