function [elemDecC]=findFocal(Theta,minSpe,maxSpe)


% Find the element of DTheta with the minium of specifity minSpe and the
% maximum maxSpe
%
% [elemDecC]=findFocal(Theta,minSpe,maxSpe)
%
% Input:
% Theta = list of coded (and eventually reduced with constraint) of the elements of
%         the discernement space
% minSpe = minimum of the wanted specificity
% minSpe = maximum of the wanted specificity
%
% Output:
% elemDec = list of elements on which we want to decide with the minium of specifity minSpe and the
% maximum maxSpe
%
% Appril 2008 Arnaud MARTIN

n=size(Theta,2);

% upper bound
% ThetaSet=[];
% for i=1:n
%     ThetaSet=union(ThetaSet,Theta{i});
% end
% nV=size(ThetaSet,2);
% nbElemDecC=0;
% for s=minSpe:maxSpe
%     nbElemDecC=nbElemDecC+nchoosek(nV,s);
% end


elemDecC{1}=[];

if minSpe==0    
    elemDecC{end+1}=[];        
end
step =1;
for i=1:n
    base(step)={[Theta{i}]};
    baseu(step)={[Theta{i}]};
    if (size(Theta{i},2)>=minSpe) && (size(Theta{i},2)<=maxSpe)    
        elemDecC{end+1}=Theta{i};        
    end
    step=step+1;
    indatom=step;
    for step2=1:indatom-2
        baseu(step)={union(baseu{indatom-1},baseu{step2})};
        if (size(baseu{step},2)>=minSpe) && (size(baseu{step},2)<=maxSpe) && isempty(findeqcell(elemDecC,baseu{step}))
            elemDecC{end+1}=baseu{step};
        end
        
        base(step)={intersect(base{indatom-1},base{step2})};
        
        if (size(base{step},2)>=minSpe) && (size(base{step},2)<=maxSpe) && isempty(findeqcell(elemDecC,base{step}))
            elemDecC{end+1}=base{step};
        end
        step=step+1;
    end
end

sBase=size(base,2);

step=1;
nbC=2;
stop=0;
D_n1 =[0 ; 1];
sDn1=2;
for nn=1:n 
    D_n =[ ] ;

    cfirst=1+(nn==n);
    for i =1:sDn1 
        Li=D_n1(i,:);
        sLi=size(Li,2);
        if (2*sLi>sBase)&& (Li(sLi-(sBase-sLi))==1)
            stop=1;
            break
        end

        for j=i:sDn1
            Lj=D_n1(j,:); 
            if((and(Li,Lj)==Li)&(or(Li,Lj)==Lj))
                D_n=[D_n ; Li Lj ] ;
                
                if size(D_n,1)>step
                    step=step+1;
                    DThetai=[];
                    for c=cfirst:nbC-1 % last intersection evrywhere exept the first time
                        if D_n(end,c)
                            if isempty(DThetai) && ~isempty(base{sBase+c-nbC})
                                DThetai=base{sBase+c-nbC};
                            else
                                DThetai=union(DThetai,base{sBase+c-nbC});
                            end
                        end
                    end
                    if (size(DThetai,2)>=minSpe) && (size(DThetai,2)<=maxSpe) && isempty(findeqcell(elemDecC,DThetai))
                        elemDecC{end+1}=DThetai;
                    end
                    
                end
            end
        end
    end
%     D_n1=D_n;
%     endloop=(nn==n);
%     jfirst=endloop+1;
%     nbR=size(D_n,1)-endloop;
%     nbC=size(D_n,2)-1;
%     for i=ifirst:nbR
%         DThetai=[];
%         for j=jfirst:nbC
%             if D_n(i,j)
%                 if isempty(DThetai)
%                     DThetai=base{sBase+j-nbC};
%                 else
%                     DThetai=union(DThetai,base{sBase+j-nbC});
%                 end
%             end
%         end
%         if (size(DThetai,2)>=minSpe) && (size(DThetai,2)<=maxSpe) && isempty(findeqcell(elemDecC,DThetai))
%             elemDecC{end+1}=DThetai;
%         end
%     end
%     ifirst=size(D_n,1)+1;

    if stop
        break
    end

    D_n1=D_n;
    sDn1=size(D_n1,1);
    nbC=2*size(D_n1,2);
end
elemDecC=elemDecC(2:end);
