function [decFocElem]=decision(expert,Theta,criterium,elemDec,r)

% Give the decision for one expert
%
% [decFocElem]=decision(expert,Theta,criterium)
%
% Inputs:
% expert = containt the structure of the list of focal elements and
% corresponding bba for all the experts
% Theta = list of coded (and reduced with constraint) of the elements of
%         the discernement space
% criterium = is the combination criterium
%                   criterium=0 maximum of the bba 
%                   criterium=1 maximum of the pignistic probability 
%                   criterium=2 maximum of the credibility
%                   criterium=3 maximum of the credibility with reject
%                   criterium=4 maximum of the plausibility
%                   criterium=5 Appriou criterium
%                   criterium=6 DSmP criterium
% elemDec = list of elements on which we can decide, 
%          or A for all, S for singletons only, F for focal elements only,
%          SF for singleton plus focal elements, Cm for given specificity, 
%          2T for only 2^Theta (DST case)
%
% Output:
% decFocElem = the retained focal element, 0 in case of rejet, -1 if the
%              decision cannot be taken on elemDec
%
% March 2008 Arnaud MARTIN
% Appril 2008 Arnaud MARTIN add the elemDec input


type=1;
switch elemDec{1}
    case 'S'
        type=0;
        elemDecC=Theta;
        expertDec=expert;
    case 'F'
        elemDecC=expert.focal;
        expertDec=expert;
    case 'SF'
        expertDec=expert;
        n=size(Theta,2);
        for i=1:n
            expertDec.focal{end+1}=Theta{i};
            expertDec.bba(end+1)=0;
        end
        expertDec=reduceExpert(expertDec);
        elemDecC=expertDec.focal;
    case 'Cm'
        type=0;
        sElem=size(elemDec,2);
        switch sElem
            case 2
                minSpe=str2num(elemDec{2});
                maxSpe=minSpe;
            case 3
                minSpe=str2num(elemDec{2});
                maxSpe=str2num(elemDec{3});
            otherwise
                'Accident in decision: with the option Cm for elemDec give the specifity of decision element (eventually the minimum and the maximum of the desired specificity'
                pause
        end
        
        elemDecC=findFocal(Theta,minSpe,maxSpe); % ! could be very high complexity 
        expertDec=expert;
%         expertDec.focal=elemDecC;
%         
%         expertDec.bba=zeros(1,size(elemDecC,2));
%         for foc=1:size(expert.focal,2)
%             ind=findeqcell(elemDecC,expert.focal{foc});
%             if ~isempty(ind)
%                 expertDec.bba(ind)=expert.bba(foc);
%             else
%                 expertDec.bba(ind)=0;
%             end
%         end
        
    case '2T'
        type=0;
        natoms=size(Theta,2);
        expertDec.focal(1)={[]};
        indFoc=findeqcell(expert.focal,{[]});
        if isempty(indFoc)
            expertDec.bba(1)=0;
        else
            expertDec.bba(1)=expert.bba(indFoc);
        end
        step =2;
        for i=1:natoms
            expertDec.focal(step)=codingFocal({[i]},Theta);
            
            indFoc=findeqcell(expert.focal,expertDec.focal{step});
            if isempty(indFoc)
                expertDec.bba(step)=0;
            else
                expertDec.bba(step)=expert.bba(indFoc);
            end
            
            step=step+1;
            indatom=step;
            for step2=2:indatom-2
                expertDec.focal(step)={[union(expertDec.focal{step2},expertDec.focal{indatom-1})]};
                
                indFoc=findeqcell(expert.focal,expertDec.focal{step});
                if isempty(indFoc)
                    expertDec.bba(step)=0;
                else
                    expertDec.bba(step)=expert.bba(indFoc);
                end
            
                step=step+1;
            end
        end
        elemDecC=expertDec.focal;
    case 'A'
        elemDecC=generationDThetar(Theta); % ! could be very high complexity 
        elemDecC=reduceFocal(elemDecC);
        expertDec.focal=elemDecC;
        expertDec.bba=zeros(1,size(elemDecC,2));
        for foc=1:size(expert.focal,2)
           expertDec.bba(findeqcell(elemDecC,expert.focal{foc}))=expert.bba(foc);
        end
    otherwise
        type=0;
        elemDec=string2code(elemDec);
        elemDecC=codingFocal(elemDec,Theta);
        expertDec=expert;
        nbElemDec=size(elemDecC,2);
        for foc=1:nbElemDec
            if ~isElem(elemDecC{foc}, expertDec.focal) 
                expertDec.focal{end+1}=elemDecC{foc};
                expertDec.bba(end+1)=0;
            end
        end
end




nbFocal=size(expertDec.focal,2);


switch criterium

    case 0
        % maximum of the bba
        nbFocal=size(expertDec.focal,2);
        nbElem=0;
        for foc=1:nbFocal
            ind=findeqcell(elemDecC,expertDec.focal{foc});
            if ~isempty(ind)
                bba(ind)=expertDec.bba(foc);
            end
        end
        [bbaMax,indMax]=max(bba);
        if bbaMax~=0
            decFocElem.bba=bbaMax;
            decFocElem.focal={elemDecC{indMax}};
        else
            decFocElem=-1;
        end
        
        
    case 1
        % maximum of the pignistic probability 
        [BetP]=pignistic(expertDec);
        decFocElem=MaxFoc(BetP,elemDecC,type);
        
    case 2
        % maximum of the credibility
        [Bel]=credibility(expertDec);
        decFocElem=MaxFoc(Bel,elemDecC,type);
        
    case 3
        % maximum of the credibility with reject
        [Bel]=credibility(expertDec);
        
        TabSing=[];
        focTheta=[];
%         for i=1:size(Theta,2)
%             focTheta=union(focTheta,Theta{i});
%         end
%         
%         for foc=1:nbFocal
%             if isElem(Bel.focal{foc}, elemDecC) 
%                TabSing=[TabSing [foc ;  Bel.Bel(foc)]];
%             end
%         end 

         for i=1:size(Theta,2)
             focTheta=union(focTheta,Theta{i});
             
             ind=findeqcell( elemDecC,Theta{i}) ;
             if ~isempty(ind)
                TabSing=[TabSing [ind ;  Bel.Bel(ind)]];
             end
         end

        [BelMax,indMax]=max(TabSing(2,:));
        if BelMax~=0
            focMax=Bel.focal{TabSing(1,indMax)};


            focComplementary=setdiff(focTheta,focMax);
            if isempty(focComplementary)
                focComplementary=[];
            end

            ind=findeqcell(Bel.focal,focComplementary);
            if BelMax < Bel.Bel(ind) % if ind is empty this is always false    
                decFocElem=0; % That means that we reject
            else
               if isempty(ind)
                   decFocElem=0; % That means that we reject
               else
                decFocElem.focal={Bel.focal{TabSing(1,indMax)}};
                decFocElem.Bel=BelMax;
               end
            end
        else
            decFocElem=-1; % That means that we cannot take the decision
        end
        
    case 4
        % maximum of the plausibility
        [Pl]=plausibility(expertDec);
        decFocElem=MaxFoc(Pl,elemDecC,type);
    case 5
        % DSmP criterium
        epsilon=0.00001; % 0 can allows problem
        
        [DSmP]=DSmPep(expertDec,epsilon);
        decFocElem=MaxFoc(DSmP,elemDecC,type);
    case 6
        % Appriou criterium
        
        [Pl]=plausibility(expertDec); 
        
        lambda=1;
        %r=0.5;
        bm=BayesianMass(expertDec,lambda,r); 
        Newbba=Pl.Pl.*bm.bba;
        % normalization
        Newbba=Newbba/sum(Newbba);
        funcDec.focal=Pl.focal;
        funcDec.bba=Newbba;
       
        decFocElem=MaxFoc(funcDec,elemDecC,type);
    case 7
        % Credibility on DTheta criterium
        
        [Bel]=credibility(expertDec); 
        
        lambda=1;
        %r=0.5;
        bm=BayesianMass(expertDec,lambda,r); 
        Newbba=Bel.Bel.*bm.bba;
        % normalization
        Newbba=Newbba/sum(Newbba);
        funcDec.focal=Bel.focal;
        funcDec.bba=Newbba;
       
        decFocElem=MaxFoc(funcDec,elemDecC,type);
    case 8
        % pignistic on DTheta criterium
        
        [BetP]=pignistic(expertDec); 
        
        lambda=1;
        %r=0.5;
        bm=BayesianMass(expertDec,lambda,r); 
        Newbba=BetP.BetP.*bm.bba;
        % normalization
        Newbba=Newbba/sum(Newbba);
        funcDec.focal=BetP.focal;
        funcDec.bba=Newbba;
       
        decFocElem=MaxFoc(funcDec,elemDecC,type);
        
    otherwise 
        'Accident: in decision choose of criterium: uncorrect'
        
end
end



%%
function [bool]=isElem(focal, listFocal)

% The g oal of this function is to return a boolean on the test focal in
% listFocal
% 
% [bool]=isElem(focal, listFocal)
% 
% Inputs:
% focal = one focal element (matrix)
% listFocal = the list of elements in Theta (all different)
%
% Output:
% bool = boolean: true if focal is in listFocal, elsewhere false
%
% March 2008 Arnaud MARTIN

n=size(listFocal,2);

bool=false;
for i=1:n
    if isequal(listFocal{i},focal)
        bool=true;
        break;
    end
end
end

%%
function [decFocElem]=MaxFoc(funcDec,elemDecC,type)

fieldN=fieldnames(funcDec);

switch fieldN{2}
    case 'BetP'
        funcDec.bba=funcDec.BetP;
    case 'Bel'
        funcDec.bba=funcDec.Bel;
    case 'Pl'
        funcDec.bba=funcDec.Pl;
    case 'DSmP'
        funcDec.bba=funcDec.DSmP;
        
end

if type 
    [funcMax,indMax]=max(funcDec.bba);
    FocMax={funcDec.focal{indMax}};
else
    nbFocal=size(funcDec.focal,2);
    TabSing=[];
    for foc=1:nbFocal
        if isElem(funcDec.focal{foc}, elemDecC) 
            TabSing=[TabSing [foc ;  funcDec.bba(foc)]];
        end
    end 
    [funcMax,indMax]=max(TabSing(2,:));
    FocMax={funcDec.focal{TabSing(1,indMax)}};
end


if funcMax~=0
    decFocElem.focal=FocMax;

    switch fieldN{2}
        case 'BetP'
            decFocElem.BetP=funcMax;
        case 'Bel'
            decFocElem.Bel=funcMax;
        case 'Pl'
            decFocElem.Pl=funcMax;
        case 'DSmP'
            decFocElem.DSmP=funcMax;
    end
else
    decFocElem=-1;
end
    
end
        
        