function [Bel]=credibility(expert)

% Credibility function
%
% [Bel]=credibility(expert)
%
% Input:
% expert = containt the structures of the list of focal element and
%          corresponding bba for all the experts
% expert.focal = list of focal elements
% expert.bba = matrix of bba
%
% Output:
% Bel = containt the structure of the list of focal element and the matrix of the
%       credibility corresponding
% Bel.focal = list of focal elements
% Bel.Bel = matrix of the credibility 

% Comment : 1- the code of the focal elements must inculde the constraints
%           2- The credibility is given only on the elements in the list of focal of expert (the
%           bba can be 0)

% March 2008 Arnaud MARTIN
% Copyright  2008 Arnaud Martin 


nbFocal=size(expert.focal,2);

Bel.focal=expert.focal;
Bel.Bel=zeros(1,nbFocal);

for focA=1:nbFocal   
    for focB=1:nbFocal
        indMem=ismember(expert.focal{focB},expert.focal{focA});
        
       if sum(indMem)==size(expert.focal{focB},2) && ~isequal(expert.focal{focB},[])
          Bel.Bel(focA)=Bel.Bel(focA)+expert.bba(focB);
       else 
           if isequal(expert.focal{focB},[]) && isequal(expert.focal{focA},[]) % the empty set is include to all the focal elements
               Bel.Bel(focA)=Bel.Bel(focA)+expert.bba(focB);
           end
       end
    end
end