function [DSmP]=DSmPep(expert,epsilon)

% DSmP Transformation
%
% [DSmP]=DSmPep(expert,epsilon)
%
% Inputs:
% expert = containt the structures of the list of focal element and
%          corresponding bba for all the experts
% expert.focal = list of focal elements
% expert.bba = matrix of bba
% epsilon = epsilon coefficient
% 
% Output:
% DSmPep = containt the structure of the list of focal element and the matrix of the
%       plausibility corresponding
% DSmPep.focal = list of focal elements
% DSmPep.DSmP = matrix of the pignistic transformation
%
% Reference: Dezert & Smarandache, ''A new probbilistic transformation of belief mass assignment'', 
%                               fusion 2008
% March 2008 Arnaud MARTIN


nbFocal=size(expert.focal,2);

DSmP.focal=expert.focal;
DSmP.DSmP=zeros(1,nbFocal);

for focA=1:nbFocal 
    for focB=1:nbFocal
       focI=intersect(expert.focal{focA},expert.focal{focB});
       sumbbaFocB=0;
       sFocB=size(expert.focal{focB},2);
       for elB=1:sFocB
           ind=findeqcell(expert.focal,expert.focal{focB}(elB));
           if ~isempty(ind)
               sumbbaFocB=sumbbaFocB+expert.bba(ind);
           end
       end
       if ~isempty(focI) 
           sumbbaFocI=0;
           sFocI=size(focI,2);
           for elB=1:sFocI
               ind=findeqcell(expert.focal,focI(elB));
               if ~isempty(ind)
                   sumbbaFocI=sumbbaFocI+expert.bba(ind);
               end
           end
           DSmP.DSmP(focA)=DSmP.DSmP(focA)+expert.bba(focB)*(sumbbaFocI+epsilon*sFocI)/(sumbbaFocB+epsilon*sFocB);
       end
    end
end