function [res]=meanbba(expert)

% Mean combination rule
%
% [res]=meanbba(expert)
% 
% Input:
% expert = containt the structures of the list of focal element and
% corresponding bba for all the experts
%
% Output:
% res = is the resulting expert (structure of the list of focal element and
% corresponding bba)
% 
% March 2008 Arnaud MARTIN


nbexpert=size(expert,2);

for i=1:nbexpert
    nbfocal(i)=size(expert(i).focal,2);
    nbbba(i)=size(expert(i).bba,2);
    if nbfocal(i)~=nbbba(i)
        'Accident: in conj: the numbers of bba and focal element are different'
    end
end

comb=expert(1);
for exp=2:nbexpert
    for foc2=1:nbfocal(exp)
        [ind]=findeqcell(comb.focal,expert(exp).focal{foc2});
        if isempty(ind)
            comb.focal{end+1}=expert(exp).focal{foc2};
            comb.bba(end+1)=expert(exp).bba(foc2);
        else
            comb.bba(ind)=comb.bba(ind)+expert(exp).bba(foc2);
        end
    end
end
comb.bba=comb.bba/nbexpert;
res=comb;

