function [res]=conjunctive(expert)

% Conjunctive Rule
% 
% [res]=conjunctive(expert)
% 
% Inputs:
% expert = containt the structures of the list of focal element and
% corresponding bba for all the experts
% 
% Output:
% res = is the resulting expert (structure of the list of focal element and
% corresponding bba)
%
% March 2008 Arnaud MARTIN


nbexpert=size(expert,2);

for i=1:nbexpert
    nbfocal(i)=size(expert(i).focal,2);
    nbbba(i)=size(expert(i).bba,2);
    if nbfocal(i)~=nbbba(i)
        'Accident: in conj: the numbers of bba and focal element are different'
    end
end

interm=expert(1);

for exp=2:nbexpert
    nbfocalInterm=size(interm.focal,2);
    i=1;
    comb.focal={};
    comb.bba=[];
    for foc1=1:nbfocalInterm
        for foc2=1:nbfocal(exp)
            tmp=intersect(interm.focal{foc1},expert(exp).focal{foc2});
            if isempty(tmp)
                tmp=[];
            end
            comb.focal(i)={tmp};
            comb.bba(i)=interm.bba(foc1)*expert(exp).bba(foc2);
            i=i+1;
        end
    end
    interm=reduceExpert(comb);
end

res=interm;

