function [res]=Zhang(expert)

% Zhang Rule 
% 
% [res]=Zhang(expert)
% 
% Inputs:
% expert = containt the structures of the list of focal element and
% corresponding bba for all the experts
% 
% Output:
% res = is the resulting expert (structure of the list of focal element and
% corresponding bba)
%
% April 2008 Arnaud MARTIN


nbexpert=size(expert,2);

for i=1:nbexpert
    nbfocal(i)=size(expert(i).focal,2);
    nbbba(i)=size(expert(i).bba,2);
    if nbfocal(i)~=nbbba(i)
        'Accident: in conj: the numbers of bba and focal element are different'
    end
end

interm=expert(1);
for exp=2:nbexpert
    nbfocalInterm=size(interm.focal,2);
    i=1;
    comb.focal={};
    comb.bba=[];
    for foc1=1:nbfocalInterm
        for foc2=1:nbfocal(exp)
            tmp=intersect(interm.focal{foc1},expert(exp).focal{foc2});
            if ~isempty(tmp);
                comb.focal(i)={tmp};
                comb.bba(i)=interm.bba(foc1)*expert(exp).bba(foc2)*size(tmp,2)/(size(interm.focal{foc1},2)*size(expert(exp).focal{foc2},2));
                i=i+1;
            end
        end
    end
    interm=reduceExpert(comb);
end

interm.bba=interm.bba./sum(interm.bba);
res=interm;

