function [res]=PCR6(expert)

% PCR6 combination rule
% 
% [res]=PCR6(expert)
% 
% Input:
% expert = containt the structures of the list of focal element and
% corresponding bba for all the experts
%
% Output:
% res = is the resulting expert (structure of the list of focal element and
% corresponding bba)
%
% Reference: A. Martin and C. Osswald, ''A new generalization of the
%           proportional conflict redistribution rule stable in terms of decision,'' 
%           Applications and Advances of DSmT for Information Fusion, Book 2,
%           American Research Press Rehoboth, F. Smarandache and J. Dezert, pp. 69-88 2006.
%
% March 2008 Arnaud MARTIN

[expertConj,tabInd]=globalConjunctive(expert);
% expertConj = containt the structures of the list of focal element and
%           corresponding bba for the expert coming from the global conjunctive
%           combination
% tabInd = table of the indices given the combination

ind=findeqcell(expertConj.focal,[]);
nbexp=size(tabInd,1);


if ~isempty(ind)
    expertConj.bba(ind)=0;
    sInd=size(ind,2);
    for i=1:sInd
        P=1;
        S=0;
        for exp=1:nbexp
            bbaexp=expert(exp).bba(tabInd(exp,ind(i)));
            P=P*bbaexp;
            S=S+bbaexp;
        end
        for exp=1:nbexp 
            expertConj.focal(end+1)=expert(exp).focal(tabInd(exp,ind(i)));
            expertConj.bba(end+1)=expert(exp).bba(tabInd(exp,ind(i)))*P/S;
        end
    end
end
res=reduceExpert(expertConj);


