function [res]=Mix(expert)

% Martin and Osswald combination rule
% 
% [res]=Mix(expert)
% 
% Input:
% expert = containt the structures of the list of focal element and
% corresponding bba for all the experts
% 
% Output:
% res = is the resulting expert (structure of the list of focal element and
% corresponding bba)
%
% Reference: A. Martin and C. Osswald, ''Toward a combination rule to deal
%            with partial conflict and specificity in belief functions theory,''
%            International Conference on Information Fusion, Quebec, Canada, 9-12 July 2007.
%
% March 2008 Arnaud MARTIN

[expertConj,tabInd]=globalConjunctive(expert);
% expertConj = containt the structures of the list of focal element and
%           corresponding bba for the expert coming from the global conjunctive
%           combination
% tabInd = table of the indices given the combination

nbexp=size(tabInd,1);
sFoc=size(expertConj.focal,2);

for i=1:sFoc
    interm=expert(1).focal{tabInd(1,i)};
    for exp=2:nbexp
       interm= union(interm,expert(exp).focal{tabInd(exp,i)});
    end
    alpha=size(expertConj.focal{i},2)/size(interm,2);
    expertConj.focal{end+1}=interm;
    expertConj.bba(end+1)=(1-alpha)*expertConj.bba(i);
    expertConj.bba(i)=alpha*expertConj.bba(i);
end

expertConjRed=reduceExpert(expertConj);

res=expertConjRed;

