function [res]=MDPCR(expert)

% MDPCR combination rule
% 
% [res]=MDPCR(expert)
% 
% Input:
% expert = containt the structures of the list of focal element and
% corresponding bba for all the experts
%
% Output:
% res = is the resulting expert (structure of the list of focal element and
% corresponding bba)
%
% Reference: A. Martin and C. Osswald, ''Toward a combination rule to deal
%            with partial conflict and specificity in belief functions theory,''
%            International Conference on Information Fusion, Quebec,
%            Canada, 9-12 July 2007.
%
% March 2008 Arnaud MARTIN



[expertConj,tabInd]=globalConjunctive(expert);
% expertConj = containt the structures of the list of focal element and
%           corresponding bba for the expert coming from the global conjunctive
%           combination
% tabInd = table of the indices given the combination


[nbexp,nbFoc]=size(tabInd);

% 
% indempty=findeqcell(expertConj.focal,[]);
% indNotempty=setdiff([1:1:nbFoc],indempty);
% sNotempty=size(indNotempty,2);


for foc=1:nbFoc
    for exp=1:nbexp
        cmp27=0; % formulae (27)
        sumbba=0; % formulae (30)
        for exp2=1:nbexp
            if exp~=exp2
                tmp=intersect(expert(exp).focal{tabInd(exp,foc)},expert(exp2).focal{tabInd(exp2,foc)});
                if ~isempty(tmp);
                    cmp27=cmp27+1;
                end
                sumbba=sumbba+expert(exp2).bba(tabInd(exp2,foc));
            end
        end
        alpha(exp,foc)=cmp27;
        gamma(exp,foc)=expert(exp).bba(tabInd(exp,foc))/(expert(exp).bba(tabInd(exp,foc))+sumbba);
    end
end
alpha=alpha/(nbexp*(nbexp-1));

sumalpha=sum(alpha);
if sumalpha
    lambda=sumalpha./sum(alpha.*gamma);  % formulae (29)
else 
    lambda=ones(1,nbFoc);
end

for i=1:nbFoc 
    interm=expert(1).focal{tabInd(1,i)};
    for exp=2:nbexp
       interm= union(interm,expert(exp).focal{tabInd(exp,i)});
    end
    
    cardFoc=size(expertConj.focal{i},2);
    if cardFoc
        alphaMix=cardFoc/size(interm,2);
        expertConj.focal{end+1}=interm;
        expertConj.bba(end+1)=(1-alphaMix)*expertConj.bba(i);
        expertConj.bba(i)=alphaMix*expertConj.bba(i);
    else
        expertFocalEmpty=expertConj.bba(i);
        expertConj.bba(i)=0;
        P=1;
        S=0;
        for exp=1:nbexp
            bbaexp=expert(exp).bba(tabInd(exp,i));
            P=P*bbaexp;
            S=S+bbaexp;
        end
        expertConj.focal{end+1}=interm;
        expertConj.bba(end+1)=(1-sumalpha(i))*expertFocalEmpty;
         for exp=1:nbexp     
             expertConj.focal(end+1)=expert(exp).focal(tabInd(exp,i)); 
             expertConj.bba(end+1)=expert(exp).bba(tabInd(exp,i))*alpha(exp,i)*lambda(i)*P/S;
         end
    end
end


res=reduceExpert(expertConj);

