function [res]=DPCR(expert)

% DPCR combination rule
% 
% [res]=DPCR(expert)
% 
% Input:
% expert = containt the structures of the list of focal element and
% corresponding bba for all the experts
%
% Output:
% res = is the resulting expert (structure of the list of focal element and
% corresponding bba)
%
% Reference: A. Martin and C. Osswald, ''Toward a combination rule to deal
%            with partial conflict and specificity in belief functions theory,''
%            International Conference on Information Fusion, Quebec,
%            Canada, 9-12 July 2007.
%
% March 2008 Arnaud MARTIN

[expertConj,tabInd]=globalConjunctive(expert);
% expertConj = containt the structures of the list of focal element and
%           corresponding bba for the expert coming from the global conjunctive
%           combination
% tabInd = table of the indices given the combination



[nbexp,nbFoc]=size(tabInd);
for foc=1:nbFoc
    for exp=1:nbexp
        cmp27=0; % formulae (27)
        sumbba=0; % formulae (30)
        for exp2=1:nbexp
            if exp~=exp2
                tmp=intersect(expert(exp).focal{tabInd(exp,foc)},expert(exp2).focal{tabInd(exp2,foc)});
                if ~isempty(tmp);
                    cmp27=cmp27+1;
                end
                sumbba=sumbba+expert(exp2).bba(tabInd(exp2,foc));
            end
        end
        alpha(exp,foc)=cmp27;
        gamma(exp,foc)=expert(exp).bba(tabInd(exp,foc))/(expert(exp).bba(tabInd(exp,foc))+sumbba);
    end
end
alpha=alpha/(nbexp*(nbexp-1));

sumalpha=sum(alpha);
if sumalpha
    lambda=sumalpha./sum(alpha.*gamma);  % formulae (29)
else 
    lambda=ones(1,nbFoc);
end


ind=findeqcell(expertConj.focal,[]);
sInd=size(ind,2);

if ~isempty(ind)
    expertFocalEmpty=expertConj.bba(ind);
    expertConj.bba(ind)=0;
    for i=1:sInd
        P=1;
        S=0;
        for exp=1:nbexp
            bbaexp=expert(exp).bba(tabInd(exp,ind(i)));
            P=P*bbaexp;
            S=S+bbaexp;
        end
        interm=expert(1).focal{tabInd(1,ind(i))};
        for exp=2:nbexp
            interm= union(interm,expert(exp).focal{tabInd(exp,ind(i))});
        end
        expertConj.focal{end+1}=interm;
        expertConj.bba(end+1)=(1-sumalpha(ind(i)))*expertFocalEmpty(i);
         for exp=1:nbexp
             expertConj.focal(end+1)=expert(exp).focal(tabInd(exp,ind(i)));
             expertConj.bba(end+1)=expert(exp).bba(tabInd(exp,ind(i)))*alpha(exp,ind(i))*lambda(ind(i))*P/S;   
         end
    end
end

res=reduceExpert(expertConj);


