function [res]=DP(expert)

% Dubois and Prade combination rule
% 
% [res]=DP(expert)
% 
% Input:
% expert = containt the structures of the list of focal element and
% corresponding bba for all the experts
% 
% Output:
% res = is the resulting expert (structure of the list of focal element and
% corresponding bba)
%
% Reference: D. Dubois and H. Prade, ''Representation and Combination of
%            uncertainty with belief functions and possibility measures,''
%            Computational Intelligence, vol. 4, pp. 244-264, 1988.
%
% March 2008 Arnaud MARTIN


[expertConj,tabInd]=globalConjunctive(expert);
% expertConj = containt the structures of the list of focal element and
%           corresponding bba for the expert coming from the global conjunctive
%           combination
% tabInd = table of the indices given the combination

ind=findeqcell(expertConj.focal,[]);
expertConjRed=reduceExpert(expertConj);

nbexp=size(tabInd,1);

if ~isempty(ind)
    sInd=size(ind,2);
    for i=1:sInd
        inter=expert(1).focal{tabInd(1,ind(i))};
        for exp=2:nbexp
           inter= union(inter,expert(exp).focal{tabInd(exp,ind(i))});
        end

        indexist=findeqcell(expertConjRed.focal,inter);
        if isempty(indexist)
            expertConjRed.focal{end+1}=inter;
            expertConjRed.bba(end+1)=expertConj.bba(ind(i));
        else
            expertConjRed.bba(indexist)=expertConjRed.bba(indexist)+expertConj.bba(ind(i));
        end
    end
end



ind=findeqcell(expertConjRed.focal,[]);

if ~isempty(ind)
    expertConjRed.bba(ind)=0;
end

res=expertConjRed;

